<?php
/*
    ===============================================================
    @author     : Surdeanu Mihai ;
    @date       : 1 iulie 2011 ;
    @version    : 3.0 ;
    @mybb       : compatibilitate cu MyBB 1.6.x ;
    @description: Aceasta modificare genereaza o lista cu grupurile de pe forumul tau, afisand-o in zona statisticilor, din subsol.
    @homepage   : http://mybb.ro ! Viziteaza-ne acum!
    @copyright  : Licenta MyBB Romania. Toate drepturile rezervate.
    ===============================================================
    @change log :
    [v3.0][1 iulie 2011] - posibilitatea rularii pe baza cache-ului, in acest fel saitul se incarca mai repede, fixarea unui posibil atac de tip SQL Injection din Admin CP;
    [v2.0][18 august 2010] - modul automat a temei, fixarea unui bug la interogarea bazei de date;
    [v1.0][5 august 2010] - prima versiune ;
    ===============================================================
*/
// Test impotriva accesarii directe, din browser a fisierului modificarii
if(!defined("IN_MYBB"))
{
    die("Acest fisier nu poate fi accesat direct.");
}
// Carligul de legatura cu forumul tau
$plugins->add_hook("index_start", "grouplegend_show");
// Functie pentru intoarcerea informatiilor despre modificare
function grouplegend_info()
{
    return array(
        "name"				=> "هاك قائمة المجموعات في الرئيسية",
        "description"		=> "يظهر مجموعات المنتدي بالرئيسية في الفوتر",
        "website"			=> "http://mybb.ro",
        "author"			=> "Surdeanu Mihai",
        "authorsite"		=> "http://mihu.me",
        "version"			=> "3.0",
		"guid"				=> "8a96dd36a70537d9ce3c47b1479fd7c1",
		'compatibility'     => "16*",
                );
}
// Functie pentru activarea modificarii
function grouplegend_activate()
{
	global $db;
	$grup_de_setari = array(
		"gid"               => NULL,
		"name"              => "ugl_mybbro",
		"title"             => "قائمة مجموعات الاعضاء بالفوتر",
		"description"       => "يقوم باضافة قائمة مجموعات الاعضاء بالفوتر بشكل انيق",
		"disporder"         => "35",
		"isdefault"         => "no"
                           );
	$db->insert_query("settinggroups", $grup_de_setari);
	$gid = $db->insert_id();
    $setare_1 = array(
        "sid"               => NULL,
        "name"              => "ugl_enabled",
        "title"             => "تفعيل الهاك ؟",
        "description"       => "تستطيع تفعيل او تعطيل الهاك ",
        "optionscode"       => "yesno",
        "value"             => "no",
        "disporder"         => "1",
        "gid"               => intval($gid)
                     );
    $setare_2 = array(
        "sid"               => NULL,
        "name"              => "ugl_cache_enabled",
        "title"             => "نظام الكاش",
        "description"       => "تستطيع تشغيل نظام الكاش لتسريع العمل والتخفيف علي السيرفر",
        "optionscode"       => "yesno",
        "value"             => "yes",
        "disporder"         => "2",
        "gid"               => intval($gid)
                     );
    $setare_3 = array(
        "sid"               => NULL,
        "name"              => "ugl_mode",
        "title"             => "شكل القائمة:",
        "description"       => " اختيار شكل ظهور القائمة ويفضل اختيار تلقائي",
        "optionscode"       => "select\n0=تلقائي\n1=بدون صور\n2=بصور",
        "value"             => "0",
        "disporder"         => "3",
        "gid"               => intval($gid)
                     );
    $setare_4 = array(
        "sid"               => NULL,
        "name"              => "ugl_orderbyelement",
        "title"             => "ترتيب الظهور :",
        "description"       => "اختيار ترتيب ظهور المجموعات طبقا لقاعدة البيانات ويفضل اختيار طبقا للعنوان",
        "optionscode"       => "select\ngid=الايدي\nusertitle=المجموعة\ntitle=العنوان",
        "value"             => "title",
        "disporder"         => "4",
        "gid"               => intval($gid)
                     );
	$setare_5 = array(
		"sid"			    => NULL,
		"name"			    => "ugl_ordergrouplegend",
		"title"			    => "مظهر الظهور :",
		"description"	    => "وهو يختص بشكل اسم المجموعة بين اقواس وخلافه ويفضل تركه كما هو.",
		"optionscode"	    => "text",
		"value"			    => "ALL[ASC]",
		"disporder"		    => "5",
		"gid"			    => intval($gid)
                     );
	$db->insert_query("settings", $setare_1);
    $db->insert_query("settings", $setare_2);  
    $db->insert_query("settings", $setare_3); 
    $db->insert_query("settings", $setare_4);    
    $db->insert_query("settings", $setare_5); 
    // se reconstruiesc toate setarile
    rebuild_settings();   
    $sablon = array(
		"tid"		=> NULL,
		"title"		=> "ugl_template",
		"template"	=> "<!-- Powered by MyBB Romania : http://mybb.ro -->\n{\$ugl_final}",
		"sid"		=> "-1"
	                 );
    // se insereaza sablonul in sistem
	$db->insert_query("templates", $sablon);
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
    // se face legatura sablonului cu tema de pe forum
	find_replace_templatesets("index_boardstats", '#{\$whosonline}#', "{\$whosonline}\n{\$ugl_userlegend}");
}
//Deactivate plugin
function grouplegend_deactivate()
{
	global $db;
    // se sterg din baza de date toate setarile adaugate de modificare
    $db->delete_query('settings', 'name IN("ugl_enabled", "ugl_cache_enabled", "ugl_mode", "ugl_orderbyelement", "ugl_ordergrouplegend")');
    $db->delete_query('settinggroups', 'name = "ugl_mybbro"');
    // se reconstruiesc toate setarile
    rebuild_settings();
    // se sterge din baza de date sablonul adaugat
    $db->delete_query('templates', 'title = "ugl_template"');       
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
    // se desface legatura sablonului cu tema de pe forum
	find_replace_templatesets("index_boardstats", '#(\n?){\$ugl_userlegend}#', '', 0);
}
// Functia de cautare, complexitate O(n)
function grouplegend_search($array, $key, $value)
{
    foreach ($array as $subarray)
        if ($subarray[$key] == $value)
            return array(
                'title' => $subarray['title'],
                'namestyle' => $subarray['namestyle']
                        );
    return array();
}
// Functia de comparare, necesara sortarii
function grouplegend_compare($array1, $array2) 
{
    global $mybb;
    // se compara ca stringuri si nu ca numere
    return strcmp($array1[$mybb->settings['ugl_orderbyelement']], $array2[$mybb->settings['ugl_orderbyelement']]);
}
// Functia de generare a template-ului
function grouplegend_template($final, $type) 
{
    if ($type == "complex") {
        return "<tr><td class=\"trow1 smalltext\" align=\"center\" width=\"1\"><img src=\"images/group_legend.png\" alt=\"Usergroup Legend\" /></td><td colspan=\"6\" class=\"trow1\"><span class=\"smalltext\">".$final."</span></td></tr>";
    }
    else {
        return "<tr><td class=\"trow1\"><span class=\"smalltext\">".$final."</span></td></tr>";   
    }
}
// Functia care face toata treaba
function grouplegend_show()
{
    // Variabile globale
    global $db, $mybb, $ugl_userlegend, $templates, $cache;
    // Variabile de lucru
	$final = "";
    // Se verifica daca acest plugin are permisiunea de a rula
    if ($mybb->settings['ugl_enabled'] == 1) 
    {
        // Se creeaza un vector cu ordinea elementelor alese
	    $ordergrouplegend = explode(',', $mybb->settings['ugl_ordergrouplegend']);
        // Versiunea 3.0 a acestui plugin utilizeaza cache-uri. Performanta este astfel sporita!
        if ($mybb->settings['ugl_cache_enabled'] == 1) 
        {
            // se merge pe varianta de caching
            $groupscache = $cache->read("usergroups");
            // daca cache-ul de grupuri de utilizatori nu exista atunci se face update
            if(!is_array($groupscache)) {
                $cache->updateusergroups();
                $groupscache = $cache->read("usergroups");
            }
            // acum totul ar trebui sa fie in regula cu cache-ul grupurilor de useri
            // verificam mai intai daca exista cuvantul cheie "all" in lista
            if (in_array("ALL[ASC]", $ordergrouplegend) || in_array("ALL[DESC]", $ordergrouplegend))
            {
                // se ordoneaza alfabetic mai intai
                usort($groupscache, "grouplegend_compare");
                if (in_array("ALL[DESC]", $ordergrouplegend)) {
                    // daca apare descrescator atunci se inverseaza array-ul
                    $groupscache = array_reverse($groupscache);
                }
                // fiecare grup din cache este afisat
                foreach ($groupscache as $grup)
                {
                    // incepe sa se creeze formatul cu tot cu titlu si culori
			        $format = $grup['namestyle'];
			        $userin = substr_count($format, "{username}");
			        if($userin == 0)
			        {
				        $format = "{username}";
			        }
			        $format = stripslashes($format);
			        $usergroup = str_replace("{username}", $grup['title'], $format);
                    // se adauga stringul la structura finala
			        $final .= " [".$usergroup."] ";
                } 
            }
            else
            {
                // pentru fiecare element din lista propusa de user
       	        foreach($ordergrouplegend as $orderelement)
                {
                    // se verifica daca exista grupul in cache
                    $rezultat = grouplegend_search($groupscache, $mybb->settings['ugl_orderbyelement'], $orderelement);
                    // daca este array nevid atunci s-a gasit rezultatul
                    if (count($rezultat) > 0)
                    {
                        // incepe sa se creeze formatul cu tot cu titlu si culori
                        $format = $rezultat['namestyle'];
                        $userin = substr_count($format, "{username}");
                        if($userin == 0) {
                            $format = "{username}";
                        }
                        $format = stripslashes($format);
                        $usergroup = str_replace("{username}", $rezultat['title'], $format);
                        // se adauga stringul la structura finala
                        $final .= " [".$usergroup."] ";
                    }
                    // pe cealalta ramura nu ne intereseaza
                    // se repeta structura repetitiva    
                }
            }
        }
        else
        {
            // verificam mai intai daca exista cuvantul cheie "all" in lista
            if (in_array("ALL[ASC]", $ordergrouplegend) || in_array("ALL[DESC]", $ordergrouplegend))
            {
                // se realizeaza interogarea
                // Versiunea 3.0 securizeaza interogarea MySQL impotriva unor injectii de tip SQL Injection din Admin CP
                if (in_array("ALL[DESC]", $ordergrouplegend)) {
                    // daca apare descrescator atunci se inverseaza interogarea
                    $interogare = $db->simple_select("usergroups", "title, namestyle", "", array("order_by" => "title", "order_dir" => "DESC"));
                }
                else {
                    $interogare = $db->simple_select("usergroups", "title, namestyle", "", array("order_by" => "title"));
                }
                // procesari de date
                while ($group = $db->fetch_array($interogare))
                {
                    // incepe sa se creeze formatul cu tot cu titlu si culori
			        $format = $group['namestyle'];
			        $userin = substr_count($format, "{username}");
			        if($userin == 0) {
				        $format = "{username}";
			        }
			        $format = stripslashes($format);
			        $usergroup = str_replace("{username}", $group['title'], $format);
                    // se aduga la stringul final
			        $final .= " [".$usergroup."] ";
                }
            }
            else 
            {
            // userul nu a ales cache-ul ca solutie pentru forumul sau
            foreach($ordergrouplegend as $orderelement)
	        {
                // se realizeaza interogarea
                // Versiunea 3.0 securizeaza interogarea MySQL impotriva unor injectii de tip SQL Injection din Admin CP
                $interogare = $db->simple_select("usergroups", "title, namestyle", $mybb->settings['ugl_orderbyelement']." = '".$db->escape_string($orderelement)."'", array("limit" => 1));
                // se creeaza vectorul cu datele
                $group = $db->fetch_array($interogare);
                // se verifica daca s-a intors ceva din baza de date
                if (!empty($group))
                {
                    // incepe sa se creeze formatul cu tot cu titlu si culori
			        $format = $group['namestyle'];
			        $userin = substr_count($format, "{username}");
			        if($userin == 0) {
				        $format = "{username}";
			        }
			        $format = stripslashes($format);
			        $usergroup = str_replace("{username}", $group['title'], $format);
                    // se aduga la stringul final
			        $final .= " [".$usergroup."] ";
                }
                // daca nu s-a intors nimic din baza de date, se trece la urmatorul element de ordine
            }
            }
         }
         // se produce afisarea datelor
         switch($mybb->settings['ugl_mode'])  
         {  
            case 2 :
                // tema avansata, cu imagini la statistici
                $ugl_final = grouplegend_template($final, "complex");
                // in sfarsit se creeaza template-ul cu datele prelucrate
                eval("\$ugl_userlegend = \"".$templates->get("ugl_template")."\";"); 
                break;
            case 1 :
                // tema simpla, fara imagini la statistici   
                $ugl_final = grouplegend_template($final, "simple");
                // in sfarsit se creeaza template-ul cu datele prelucrate
                eval("\$ugl_userlegend = \"".$templates->get("ugl_template")."\";"); 
                break;
            default :
                // cazul in care este setat pe Automatic
                // va trebui sa procesam template-ul mama si sa vedem daca are sau nu mai multe coloane
                if (strpos($templates->get("index_whosonline"), "colspan") === false) {
                    // atunci e tema simpla
                    $ugl_final = grouplegend_template($final, "simple");
                }
                else {
                    // e tema avansata, complexa
                    $ugl_final = grouplegend_template($final, "complex");
                }
                eval("\$ugl_userlegend = \"".$templates->get("ugl_template")."\";"); 
         }
     }
    // daca pluginul nu e activ nu se intampla nimic !
}
?>